import pandas as pd   
import pickle
from decision_company import read_csv_file, create_condition, logical_and, filter_by_condition
  
# Load the dataset using the custom function  
credit_customers = read_csv_file("credit_customers.csv") 
  
# Create conditions for filtering the dataset  
credit_amount_condition = create_condition(credit_amount_column, credit_amount_75th)  
duration_condition = create_condition(duration_column, duration_75th)  
  
# Combine conditions  
combined_condition = logical_and(credit_amount_condition, duration_condition)  
  
# Filter the dataset based on the combined condition  
high_credit_long_duration = filter_by_condition(credit_customers, combined_condition)  
  
print(f"high_credit_long_duration: {high_credit_long_duration}")  
pickle.dump(high_credit_long_duration, open("./ref_result/high_credit_long_duration.pkl","wb"))